state PermafrostSpells in W3MagicVigil
{
	var damage_action			 						: W3DamageAction;
	var damage_value									: float;
	var actors 											: array<CActor>;
	var i												: int;
	var main_effect, effect_entity  					: CEntity;
	var target											: CActor; 
	var entities 										: array<CGameplayEntity>; 
	var position 										: Vector;
	var rotation 										: EulerAngles;
	var slotMatrix 										: Matrix;
	var permafrost_trap   								: W3PermafrostTrap;
	var ents_destroy									: array< CEntity >;
	var duration										: float;
	var CustomEffect									: SCustomEffectParams;
	var castDir											: Vector;
	var targetPosition									: Vector;
	var icespear										: W3PermafrostSpear;
	var dummy											: CEntity;
	var dummy_proj                                      : W3PermafrostDummy;

	event OnEnterState( prevStateName : name )
	{
		if ( !theSound.SoundIsBankLoaded("magic_caranthil.bnk") )
		{
			theSound.SoundLoadBank( "magic_caranthil.bnk", false );
		}
		if ( !theSound.SoundIsBankLoaded("ep2_mutations_06.bnk") )
		{
			theSound.SoundLoadBank( "ep2_mutations_06.bnk", false );
		}
		if ( !theSound.SoundIsBankLoaded("magic_sorceress.bnk") )
		{
			theSound.SoundLoadBank( "magic_sorceress.bnk", false );
		}
	
		if ( parent.act_signtype == ST_Axii )
		{
			if ( parent.actor && parent.actor.IsAlive() )
			{
				thePlayer.SetSlideTarget( parent.actor );
			}
			else
			{
				thePlayer.AddCustomOrientationTarget( OT_CameraOffset, 'MagicSpells' );
			}
		}
		else
		if ( !theGame.GetInGameConfigWrapper().GetVarValue('magic_spells_main', 'cast_to_camera') )
		{
			if ( !GetMagicVigil().IsAlt() )
			{
				if ( parent.actor && parent.actor.IsAlive() )
				{
					thePlayer.SetSlideTarget( parent.actor );
				}
				else
				{
					thePlayer.AddCustomOrientationTarget( OT_CameraOffset, 'MagicSpells' );
				}
			}
		}
		else
		{
			thePlayer.AddCustomOrientationTarget( OT_CameraOffset, 'MagicSpells' );
		}
		
		if ( parent.alternate )
		{
			thePlayer.PushState( 'camera_hack' );     
		}
	}
	
	event OnCastSpellAnimation( animEventName : name, animEventType : EAnimationEventType, animInfo : SAnimationEventAnimInfo )
	{
		if ( animEventName == 'cast_begin' )
		{
		}
		else if ( animEventName == 'cast_throw' )
		{
			cast_spells_permafrost();
			thePlayer.RemoveCustomOrientationTarget( 'MagicSpells' );
		}
		else if ( animEventName == 'cast_end' )
		{
			cast_spells_axii_permafrost();
			parent.GotoState( 'Vigil_Dreaming' );
		}
	}
	
	private function cast_spells_permafrost()
	{
		switch( parent.spell_name )
		{
			case 'permafrost_trap':
				{
					theGame.GetEntitiesByTag('permafrost_trap_spells',ents_destroy);
					for( i=0; i<ents_destroy.Size(); i+=1 )
					{
						ents_destroy[i].AddTimer('destroy_permafrost_trap',0.0f);
					} 	
						
					if ( parent.actor && parent.actor.IsAlive() && parent.actor.IsOnGround() && IsRequiredAttitudeBetween(thePlayer, parent.actor, true, false, false)  )
					{
						position = parent.actor.GetWorldPosition();
					}
					else
					{
						position = thePlayer.GetWorldPosition() + thePlayer.GetWorldForward()*3;
						position = find_position_spells( position );
					}
						
					rotation = thePlayer.GetWorldRotation();
					
					duration = 10;
					duration += duration * ( GetMagicVigil().get_magic_spellpower() * 0.5 );
					
					theGame.GetSurfacePostFX().AddSurfacePostFXGroup( TraceFloor( position ), 1.f, duration, 1.f, 10.f, 0);
						
					parent.templatename = "dlc\magicspellsrev\data\entities\permafrost_trap.w2ent";
						
					permafrost_trap = (W3PermafrostTrap)theGame.CreateEntity( (CEntityTemplate)LoadResource( parent.templatename ,true ), TraceFloor( position ), rotation );
					permafrost_trap.AddTimer('destroy_permafrost_trap', duration );
					permafrost_trap.AddTag('permafrost_trap_spells');
					permafrost_trap.AddTag( 'spells_from_sign' );
					
					Spells_drain_stamina( parent.stamina_cost, parent.stamina_delay, parent.signskill );
				}

				break;
			case 'permafrost_cone':
				{
					thePlayer.CalcEntitySlotMatrix('l_weapon', slotMatrix);
					position = MatrixGetTranslation(slotMatrix);
					rotation = MatrixGetRotation(slotMatrix);
						
					castDir 		= MatrixGetAxisX( slotMatrix );
					castDir.Z 		= ClampF( castDir.Z, 0, 10 );
					targetPosition 	= position + ( 5 * castDir );
						
					parent.hand_aim_position = position;
					parent.hand_aim_direction = castDir;
						
					rotation.Roll = ClampF(rotation.Roll,-100,10);
					
					parent.templatename = "dlc\magicspellsrev\data\entities\permafrost.w2ent";
					
					main_effect = (CEntity)theGame.CreateEntity( (CEntityTemplate)LoadResource( parent.templatename ,true ), position, rotation );
					main_effect.PlayEffect('permafrost_cone');
					main_effect.DestroyAfter(10);
			
					dummy_proj = (W3PermafrostDummy)theGame.CreateEntity( (CEntityTemplate)LoadResource( "dlc\magicspellsrev\data\entities\permafrost_dummy_projectile.w2ent",true ), position );
					dummy_proj.AddTag( 'spells_custom_projs' );
					dummy_proj.Init(NULL);
					dummy_proj.ShootProjectileAtPosition(0,	15, targetPosition, 10 );
					dummy_proj.DestroyAfter(10);
					
					Spells_drain_stamina( parent.stamina_cost, parent.stamina_delay, parent.signskill );
				}
				
				break;
			default:		
				break;
		}
	}
	
	private function cast_spells_axii_permafrost()
	{
		var vector_attach : Vector;
	
		if ( parent.spell_name == 'permafrost_spear' )
		{
			if ( parent.actor && parent.actor.IsAlive() && IsRequiredAttitudeBetween(thePlayer, parent.actor, true, false, false) )
			{
				targetPosition = parent.actor.GetBoneWorldPosition( spells_get_pelvis_name( parent.actor ) );
				targetPosition.Z += 0.3;
			
				parent.templatename = "dlc\magicspellsrev\data\entities\permafrost_icespear.w2ent";

				vector_attach = Vector( -0.2, 0.07, 0.05 );

				icespear = (W3PermafrostSpear)theGame.CreateEntity( (CEntityTemplate)LoadResource( parent.templatename, true ), thePlayer.GetWorldPosition() );
				icespear.CreateAttachment( thePlayer, 'l_weapon', vector_attach );
				icespear.AddTag( 'spells_custom_projs' );
				icespear.AddTag( 'spells_from_sign' );
				icespear.Init(NULL);
				icespear.PlayEffect( 'fire_fx' );
				icespear.PlayEffect( 'fire_fx2' );
				icespear.BreakAttachment();
				icespear.ShootProjectileAtPosition(0, 15, targetPosition );
				icespear.DestroyAfter(10);

				effect_entity = (CEntity)theGame.CreateEntity( (CEntityTemplate)LoadResource( 'permafrost_effects' ), thePlayer.GetWorldPosition() ) ;
				effect_entity.CreateAttachment( thePlayer, 'l_weapon', vector_attach );
				effect_entity.PlayEffect( 'permafrost_shot' );
				effect_entity.DestroyAfter(3);
				
				Spells_drain_stamina( parent.stamina_cost, parent.stamina_delay, parent.signskill );
				
				thePlayer.SetCombatIdleStance( 1.f );
			}
		}
	}
	
	event OnLeaveState( nextStateName : name )
	{
	}
}